/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.designimporter;

import java.util.List;

/**
 * Encapsulates the result of the design package import.
 */
public class DesignImportResult {

    private Status status;

    private List<String> warnings;

    public DesignImportResult(List<String> warnings) {
        this.warnings = warnings;

        if (warnings == null || warnings.size() == 0)
            status = Status.Successful;
        else
            status = Status.Warnings;
    }

    /**
     * Import result status
     */
    public enum Status {
        Successful, Warnings
    }

    /**
     * Gets the list of warnings that occurred during the import process
     * @return The list of warnings that occurred during the import process
     */
    public List<String> getWarnings() {
        return warnings;
    }

    /**
     * Indicates if the import process was free of any errors and warnings.
     *
     * @return true if the import process completed without any errors or warnings.
     */
    public boolean isSuccessful() {
        return status == Status.Successful;
    }

    /**
     * Indicates if any warnings occured during the import of the design package.
     *
     * @return true if any warnings were logged during the import of the design package.
     */
    public boolean hasWarnings() {
        return status == Status.Warnings;
    }

    /**
     * Result of design package import
     *
     * @return Status enum
     */
    public Status getStatus() {
        return status;
    }
}
