/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2015 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

package com.adobe.cq.dam.cfm;

/**
 * This class represents a generic exception in handling content fragments.
 */
public class ContentFragmentException extends Exception {

    /**
     * Create a new content fragment exception.
     *
     * @param msg A message describing the exception
     */
    public ContentFragmentException(String msg) {
        super(msg);
    }

    /**
     * Creates a new nested content fragment exception.
     *
     * @param msg A message describing the exception
     * @param cause The cause of the exception
     */
    public ContentFragmentException(String msg, Throwable cause) {
        super(msg, cause);
    }

}
