/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.auth.oauth;

/**
 * Constants related to {@link AccessTokenProvider} providers and
 * {@link AccessTokenRequestCustomizer} customizers.
 *
 * @since 3.6
 */
@org.osgi.annotation.versioning.ProviderType
public interface AccessTokenProviderConstants {

    /**
     * The key name to reference a JWT in a request context.
     * <p>
     * The value referenced is of type {@link String} and consists of a JSON Web Token.
     *
     * @see AccessTokenRequestCustomizer
     */
    String CONTEXT_JWT = "jwt";

    /**
     * The key name to reference the URI used to obtain an access token in a request context.
     * <p>
     * The value referenced is of type {@link String} and consists of a URI.
     *
     * @see AccessTokenRequestCustomizer
     */
    String CONTEXT_URI = "uri";

    /**
     * The key name to reference the default parameters in a request context.
     * <p>
     * The value referenced is of type {@link java.util.Map}&lt;{@link String},{@link String}&gt;.
     *
     * @see AccessTokenRequestCustomizer
     */
    String CONTEXT_PARAMETERS = "parameters";

    /**
     * The key name to reference the default headers in a request context.
     * <p>
     * The value referenced is of type {@link java.util.Map}&lt;{@link String},{@link java.util.List}&lt;{@link String}&gt;&gt;.
     *
     * @see AccessTokenRequestCustomizer
     */
    String CONTEXT_HEADERS = "headers";

    /**
     * grant_type as in <a href=https://tools.ietf.org/html/rfc7523>rfc7523</a>
     */
    String GRANT_TYPE = "grant_type";

    /**
     * client_id as in <a href=https://tools.ietf.org/html/rfc7523>rfc7523</a>
     */
    String CLIENT_ID = "client_id";

    /**
     * scope as in <a href=https://tools.ietf.org/html/rfc7523>rfc7523</a>
     */
    String SCOPE = "scope";

    /**
     * assertion as in <a href=https://tools.ietf.org/html/rfc7523>rfc7523</a>
     */
    String ASSERTION = "assertion";
}