/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2021 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.adobe.granite.auth.saml.spi;

import org.apache.sling.auth.core.spi.AuthenticationInfo;
import org.jetbrains.annotations.NotNull;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public interface SamlHook {
    /**
     * This handler is executed after the synchronization of the user in OAK Repository.
     * It can be used to extend the user profile by adding/modifying attributes.
     *
     * If SamlHookException is thrown, the authentication of current user fails.
     * Remark that the user created in OAK is not be deleted by SAML Authentication Handler.
     * If cleanup is required by the hooks, it must be implemented in the same.
     *
     * When SamlHookException is thrown a debug message is logged in AEM.
     * If error must be logged, then the hook must do that.
     *
     * @param request
     * @param response
     * @param assertion
     * @param authenticationInfo
     * @param samlResponse
     * @throws SamlHookException
     */
    void postSyncUserProcess(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Assertion assertion,
                             @NotNull AuthenticationInfo authenticationInfo, @NotNull String samlResponse) throws SamlHookException;

    /**
     * This handler is executed before the synchronization of the user in OAK Repository.
     * It can be used to perform additional check after that SAML is validated.
     * <p>
     * If SamlHookException is thrown, the authentication of current user fails.
     * When SamlHookException is thrown a debug message is logged in AEM.
     *
     * @param request
     * @param assertion
     * @param samlResponse
     * @throws SamlHookException
     */
    void postSamlValidationProcess(@NotNull HttpServletRequest request, @NotNull Assertion assertion, @NotNull Message samlResponse) throws SamlHookException;
}
