/*
 * ADOBE CONFIDENTIAL
 * __________________
 *
 * Copyright 2011 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
package com.adobe.granite.crypto;

import java.security.GeneralSecurityException;

/**
 * The <code>CryptoException</code> is thrown by the service methods of the {@link CryptoSupport} service. Generally
 * exceptions of this type will provide more information on the encryption or decryption failure in the
 * <code>getCause()</code> method.
 */
public class CryptoException extends GeneralSecurityException {

    private static final long serialVersionUID = 1L;

    public CryptoException(final String message) {
        super(message);
    }

    public CryptoException(final String message, final Throwable cause) {
        super(message, cause);
    }

}
