/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.httpcache.api;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

import org.osgi.annotation.versioning.ProviderType;

/**
 * A cache file contains the response headers and body that can be delivered
 * on subsequent requests for the same resource.
 *
 * TODO: currently there are methods that only makes sense while either using
 *       an existing cache file or creating a new one: it might be more
 *       appropriate to create separate interfaces for that.
 */
@ProviderType
public interface CacheFile {

    /**
     * Return the cache key.
     *
     * @return cache key
     */
    public String getKey();

    /**
     * Return the HTTP response headers stored with this entry.
     *
     * @return response headers
     */
    public Headers getHeaders();

    //---------------------------------------------------------- read-only mode

    /**
     * Spool the cache file's contents to a response.
     *
     * @param response servlet response
     * @throws IOException if an I/O error occurs
     */
    public void spool(HttpServletResponse response) throws IOException;

    //---------------------------------------------------------- write-only mode

    /**
     * Open an output stream that will contain a copy of the response body.
     *
     * @param base base output stream
     * @return servlet output stream
     * @throws IOException if an I/O error occurs
     */
    public ServletOutputStream getOutputStream(ServletOutputStream base) throws IOException;

    /**
     * Open a print writer.
     *
     * @param base base writer
     * @param encoding response body encoding
     * @return writer
     * @throws IOException if an I/O error occurs
     */
    public PrintWriter getWriter(PrintWriter base, final String encoding) throws IOException;

    /**
     * Keep this cache file.
     *
     * @return <code>true</code> if the save was successful;
     *         <code>false</code> otherwise
     */
    public boolean save();

    /**
     * Discard this cache file.
     */
    public void discard();
}
