/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.oauth.jwt;

/**
 * The {@code JwtValidator} provides an API to validate JWT formatted token
 * as defined in http://tools.ietf.org/html/draft-ietf-oauth-json-web-token-16
 */
public interface JwtValidator {

    /**
     * Validates the JWT with regards to the "nbf" (not before) and "exp" (expiration time) claims being valid at the
     * given time.
     *
     * @param jwt the Jwt to validate
     * @param time a UTC timestamp for checking the validity
     * @return {code true} if the JWT can be accepted for processing, {@code false} otherwise
     */
    boolean validate(String jwt, long time);

}
