/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.adobe.granite.replication.treeactivation;

import java.util.Collection;

import org.apache.sling.event.jobs.Job;

public interface TreeActivationService {

    /**
     * Start a new tree activation
     * 
     * @param parameters parameters
     * @return id tree activation id
     */
    String start(ActivationParameters parameters);

    /**
     * Cancel given tree activation
     * @param id activation id
     */
    void stop(String id);

    /**
     * Get active and queued jobs for a tree activation
     * @param activiationId
     * @return list of jobs
     */
    Collection<Job> list(String activiationId);

    /**
     * Delete history of tree activation jobs by activation id
     * @param id tree activation id
     */
    void delete(String id);
}
