/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.rest;

import org.osgi.annotation.versioning.ConsumerType;

/**
 * The {@code ApiResourceProviderFactory} defines the service interface to get
 * and create {@code ApiResourceProviders}'s dynamically on a per usage base.
 * <p>
 * Implementations of this interface must be defined as OSGi services and define
 * a service registration property
 * {@link ApiResourceProviderFactory#PROVIDER_TYPE}. The
 * {@code ApiResourceProviderFactory} will be selected by the value returned by
 * {@link ApiResourceProviderFactory#getContextPath()}.
 */
@ConsumerType
public interface ApiResourceProviderFactory {

    /**
     * The name of the service registration property containing the API type
     * this provider is registered with (value is "provider.type").
     */
    String PROVIDER_TYPE = "provider.type";

    /**
     * Returns the context path of the ApiResourceProviderFactory under which
     * the {@link ApiResourceProvider} will be responsible to return
     * {@link org.apache.sling.api.resource.Resource resources}.
     * 
     * @return The context path this ApiResourceProviderFactory is responsible for
     */
    String getContextPath();

    /**
     * Returns a new {@link ApiResourceProvider} instance.
     *
     * @param rootContextPath The root context path of the default API servlet.
     *            By default the value is {@code /api}.
     * @return A {@link ApiResourceProvider}.
     */
    ApiResourceProvider getResourceProvider(String rootContextPath);

}
