/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2016 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/

package com.adobe.granite.ui.components;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;

@ObjectClassDefinition(name ="Form Restriction",
    description="Configuration to allow or form submission over certain paths")
public @interface FormConfig {
    String PID = "com.adobe.granite.ui.components.FormRestrict";

    static final String PREVENT = "prevent";

    static final String POPUP = "popup";

    @AttributeDefinition(name = "Allowed paths",
        description = "Paths that are allowed to be POST using form")
    String[] allowed_paths() default { "^/content/.*" };

    @AttributeDefinition(name = "restrict behaviour",
        description = "restriction on other paths based on either a popup or be prevented",
        options = {
            @Option(label = PREVENT, value = PREVENT),
            @Option(label = POPUP, value = POPUP)
        }
    )
    String restrict_behavior() default POPUP;
}
