/*************************************************************************
* ADOBE CONFIDENTIAL
* ___________________
*
* Copyright 2014 Adobe
* All Rights Reserved.
*
* NOTICE: All information contained herein is, and remains
* the property of Adobe and its suppliers, if any. The intellectual
* and technical concepts contained herein are proprietary to Adobe
* and its suppliers and are protected by all applicable intellectual
* property laws, including trade secret and copyright laws.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe.
**************************************************************************/
package com.adobe.granite.ui.components.rendercondition;

import java.io.IOException;

import javax.annotation.Nonnull;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;

/**
 * A condition that act as an aggregate using composite pattern. The child
 * resources are evaluated recursively to finally come up with final decision.
 */
public abstract class AbstractCompositeRenderCondition implements RenderCondition {
    protected SlingHttpServletRequest request;
    protected SlingHttpServletResponse response;
    protected Resource resource;

    public AbstractCompositeRenderCondition(@Nonnull SlingHttpServletRequest request,
            @Nonnull SlingHttpServletResponse response, @Nonnull Resource resource) {
        this.request = request;
        this.response = response;
        this.resource = resource;
    }

    /**
     * Calls the given render condition resource.
     *
     * @param resource
     *            The resource
     * @return The render condition
     * @throws ServletException
     *             in case a servlet error occurs
     * @throws IOException
     *             in case a IO error occurs
     */
    @Nonnull
    protected RenderCondition call(@Nonnull Resource resource) throws ServletException, IOException {
        ValueMap vm = resource.getValueMap();

        @SuppressWarnings("null")
        String resourceType = vm.get(ResourceResolver.PROPERTY_RESOURCE_TYPE,
                "granite/ui/components/coral/foundation/renderconditions/simple");

        RequestDispatcher dispatcher = request.getRequestDispatcher(resource,
                new RequestDispatcherOptions(resourceType));

        if (dispatcher != null) {
            try {
                dispatcher.include(request, response);

                RenderCondition condition = (RenderCondition) request.getAttribute(RenderCondition.class.getName());

                if (condition != null) {
                    return condition;
                }
            } finally {
                request.removeAttribute(RenderCondition.class.getName());
            }
        }

        return SimpleRenderCondition.TRUE;
    }
}
