/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2006 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.internal.io.stream;

import java.io.IOException;

/**
 * @author sgill
 *
 */
/*package protected*/ class OutputStreamImpl extends SkippingOutputStream
{
	OutputByteStream obs;

	/**
	 * 
	 */
	OutputStreamImpl(OutputByteStream obs)
	{
		super();
		this.obs = obs;
	}

	/* (non-Javadoc)
	 * @see java.io.OutputStream#close()
	 */
	public void close()
	throws IOException
	{
		super.close();
		obs = null;
	}

	/* (non-Javadoc)
	 * @see java.io.OutputStream#flush()
	 */
	public void flush()
	throws IOException
	{
		this.obs.flush();
	}

	/* (non-Javadoc)
	 * @see java.io.OutputStream#write(int)
	 */
	public void write(int b)
	throws IOException
	{
		this.obs.write(b);
	}

	/* (non-Javadoc)
	 * @see java.io.OutputStream#write(byte[], int, int)
	 */
	public void write(byte[] b, int off, int len)
	throws IOException
	{
		this.obs.write(b, off, len);
	}

	/* (non-Javadoc)
	 * @see java.io.OutputStream#write(byte[])
	 */
	public void write(byte[] b)
	throws IOException
	{
		this.obs.write(b);
	}

	public void skip(long count) throws IOException
	{
		long position = this.obs.getPosition();
		this.obs.seek(position + count);
	}
}
