/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.localeset;

import org.xml.sax.Attributes;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Element;
import com.adobe.xfa.Model;
import com.adobe.xfa.ModelFactory;
import com.adobe.xfa.ModelPeer;
import com.adobe.xfa.Node;
import com.adobe.xfa.STRS;
import com.adobe.xfa.XFA;


/**
 * A class to represent XFA locale set model factories.  A locale set
 * model factory is used by an application model to create a locale set
 * model where appropriate, when loading an XML file.
 */
public final class LocaleSetModelFactory extends ModelFactory {

	/**
	 * Instantiates a locale set model factory. 
	 */
	public	LocaleSetModelFactory() {
		super(XFA.LOCALESETTAG, XFA.LOCALESET, STRS.DOLLARLOCALESET);
	}

	/**
	 * @exclude from published api.
	 */
	protected Model newModel(AppModel parent, Node prevSibling, String uri, String localName, String qName, Attributes a) {
		LocaleSetModel lsm = new LocaleSetModel(parent, prevSibling);
		lsm.setXmlPeer(new ModelPeer(
				(Element)parent.getXmlPeer(), null, 
				uri, localName, qName, 
				a, lsm));
		lsm.setDOMProperties(uri, localName, qName, null);

		return lsm;
	}

	/**
	 * @exclude from published api.
	 */
	public Model createDOM(Element parent)	{
		
		LocaleSetModel lsm = new LocaleSetModel(parent.getAppModel(), null);
		
		ModelPeer modelPeer = new ModelPeer(
				parent, null, 
				LocaleSetModel.localeSetNS(), XFA.LOCALESET, XFA.LOCALESET, 
				null, lsm);
		
		lsm.setXmlPeer(modelPeer);
		lsm.connectPeerToDocument();
		
		return lsm;
	}
}