/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */

package com.adobe.xfa.template.ui;

import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumAttr;
import com.adobe.xfa.EnumValue;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.XFA;

/**
 * Functionality represented by the <textEdit> element.
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */

public final class TextEdit extends ProtoableNode {

	public TextEdit(Element parent, Node prevSibling) {
		super(parent, prevSibling, null, XFA.TEXTEDIT, XFA.TEXTEDIT, null,
				XFA.TEXTEDITTAG, XFA.TEXTEDIT);
	}

	public Attribute newAttribute(int eTag, String value) {
		if (eTag == XFA.MULTILINETAG && value.length() == 0)
			return defaultAttribute(eTag);

		return super.newAttribute(eTag, value);
	}

	public Attribute defaultAttribute(int eTag) {
		if (eTag == XFA.MULTILINETAG || eTag == XFA.ALLOWRICHTEXTTAG) {
			Element pUI = getXFAParent();
			if (pUI != null) {
				Element pContainer = pUI.getXFAParent();
				if (pContainer != null) {
				
					boolean bField = pContainer.isSameClass(XFA.FIELDTAG);
					if (eTag == XFA.MULTILINETAG && bField)
						return EnumValue.getEnum(XFA.MULTILINETAG, EnumAttr.getEnum(EnumAttr.BOOL_FALSE));

					// else ALLOWRICHTEXTTAG
					if (bField || pContainer.isSameClass(XFA.DRAWTAG)) {
						Element pValue = pContainer.getElement(XFA.VALUETAG, true,0,false,false);
						if (pValue != null && !pValue.isDefault(true)) {
							Node pContent = pValue.getOneOfChild(true,false);
							if (pContent != null && pContent.isSameClass(XFA.EXDATATAG))
								return EnumValue.getEnum(XFA.ALLOWRICHTEXTTAG, EnumAttr.getEnum(EnumAttr.BOOL_FALSE));
						}
					}
				}
			}
		}

		// Not special case, so let the base class handle it
		return super.defaultAttribute(eTag);
	}

}
