/*
 * File: ISchemaGenerationTraceHandler.java
 * ************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.xmp.schema.rng.parser;

import com.adobe.xmp.schema.rng.parser.exceptions.RNGParseException;

/**
 * This interface generates a trace of traversals of ref elements encountered in rng schema. Methods in 
 * this interface provide information about namespaces, prefixes and names of various properties defined in schema.
 * Implementations of this interface can store this information for later use.
 *   
 * This can also be useful in debugging, as it helps in knowing which part of rng schema is parsed at present
 * 
 * @author hraghav
 */
public interface SchemaGenerationHandler
{
	/**
	 * Called when a new rng:ref element is encountered.
	 * 
	 * @param refName
	 */
	void startRefTraversal(String refName);

	/**
	 * Called when a rng:ref element is completely traversed.
	 * 
	 * @param refName
	 */
	void endRefTraversal(String refName);

	/**
	 * Called before constructing schema
	 * 
	 * @param ns      Namespace of schema
	 * @param prefix  Prefix of schema as defined in RelaxNG schemas
	 */
	void startSchemaConstruction(String ns, String prefix);
	
	/**
	 * Called before constructing a property
	 * 
	 * @param ns         Namespace of property
	 * @param localName  Name of property
	 * @param prefix     Prefix of property as defined in RelaxNG schemas
	 */
	void startPropertyConstruction(String ns, String localName, String prefix);

	/**
	 * Reports if a RNGParseException is raised while trying to create a {@link com.adobe.xmp.schema.model.PropertyDescription} from RNG schema.
	 * 
	 * @param ns
	 *            Property namespace
	 * @param localName
	 *            Property's localname
	 * @param ex
	 *            {@link RNGParseException} raised while constructing the property
	 * @return <code>false</code> if this parsing is to be discontinued, <code>true</code> if the error for this
	 *         property is to be ignored while constructing the schema
	 */
	boolean ignoreErrorInConstructingProperty(String ns, String localName, RNGParseException ex);
}
