/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.analytics.sitecatalyst;

import java.util.Set;

import org.apache.commons.collections.map.MultiValueMap;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;

import com.day.cq.commons.inherit.InheritanceValueMap;

public interface FrameworkComponent extends InheritanceValueMap {

    /**
     * Returns the resource type of this component.
     * 
     * @return Resource type
     */
    String getType();

    /**
     * Return the path of this component.
     * 
     * @return Component path
     */
    String getPath();

    /**
     * Returns a concatenated array of variable and event names.
     * 
     * @return String array of variable and event names
     */
    String[] getTrackedVarsEvents();

    /**
     * Returns a {@link org.apache.commons.collections.map.MultiValueMap} of the
     * CQ mapping, using CQ variables as keys.
     * 
     * @return {@link org.apache.commons.collections.map.MultiValueMap} of the
     * CQ mapping
     */
    MultiValueMap getCqMappings();

    /**
     * Returns a {@link org.apache.sling.commons.json.JSONArray} of the
     * SiteCatalyst mapping.
     * @param cqVar  CQ Variable
     * 
     * @return SiteCatalyst Mapping for given CQ Variable
     */
    JSONArray getScVars(String cqVar);

    /**
     * Returns a set of SiteCatalyst variables mapped in this or inherited
     * framework component.
     * 
     * @return Set of SiteCatalyst variable names.
     */
    Set<String> inheritedKeySet();

    /**
     * Returns a {@link org.apache.sling.api.resource.ValueMap} of the
     * components <code>analytics</code> node.
     * 
     * @return Analystics properties
     */
    ValueMap getAnalyticsProperties();

}