/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.commons.predicate;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.apache.commons.collections.Predicate;
import com.day.cq.commons.jcr.JcrConstants;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Predicate used to filter Hierarchy nodes BUT not nt:file nodes.
 * @deprecated use  {@link com.day.cq.commons.predicates.HierarchyNotFilePredicate} instead
 */
@Component(metatype = false)
@Service(Predicate.class)
@Properties({
        @Property(name = "predicate.name", value = "hierarchyNotFile")
})
@Deprecated
public class HierarchyNotFilePredicate extends AbstractNodePredicate implements Predicate {
    private final Logger log = LoggerFactory.getLogger(HierarchyNotFilePredicate.class);

    /**
     * {@inheritDoc}
     *
     * @return <code>true</code> if node is nt:hierarchyNode but not nt:file
     * @deprecated use  {@link com.day.cq.commons.predicates.HierarchyNotFilePredicate#test(Node)} instead
     */
    @Deprecated
    public boolean evaluate(Node node) throws RepositoryException {
        log.warn("HierarchyNotFilePredicate has been deprecated. Please use com.day.cq.commons.predicates.HierarchyNotFilePredicate instead.");
        return node.isNodeType(JcrConstants.NT_HIERARCHYNODE)
                && !node.isNodeType(JcrConstants.NT_FILE);
    }

}

