
/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.dam.api;

import com.day.crx.JcrConstants;

/**
 * The <code>DamConstants</code> interface defines common used dam constants
 */
public interface DamConstants {
	
	/**
	 * The Apps directory
	 */
	static final String APPS = "/apps";
	
	/**
	 * The Libs directory
	 */
	static final String LIBS = "/libs";


    /**
     * The repository path (mount point) under which asset binaries are stored.
     */
    static final String MOUNTPOINT_BINARIES = "/var/dam";

    /**
     * The repository path (mount point) under which asset metadata is stored.
     */
    static final String MOUNTPOINT_ASSETS = "/content/dam";

    /**
     * Renditions folder name
     */
    static final String RENDITIONS_FOLDER = "renditions";

    /**
     * metadata folder name
     */
    static final String METADATA_FOLDER = "metadata";
    
    /**
     * folder for saving the asset usage records
     */
    static final String USAGES_FOLDER = "usages";

    /**
     * modifier folder name
     */
    static final String MODIFIER_FOLDER = "modifier";

    /**
     * Asset node type
     */
    static final String NT_DAM_ASSET = "dam:Asset";
    /**
     * Asset Child Count
     */
    static final String NT_DAM_CHILDCOUNT = "dam:childCount" ;
    /**
     * Asset content(jcr:content) node type
     */
    static final String NT_DAM_ASSETCONTENT = "dam:AssetContent";

    /**
     * Original file name
     */
    static final String ORIGINAL_FILE = "original";

    /**
     * Current original flag property name
     */
    static final String CURRENT_ORIGINAL = "currentOriginal";

    /**
     * Subassets "folder" name
     */
    static final String SUBASSETS_FOLDER = "subassets";

    /**
     * thumbnail content type
     */
    static final String THUMBNAIL_MIMETYPE = "image/png";

    /**
     * node types
     */
    static final String NT_SLING_ORDEREDFOLDER = "sling:OrderedFolder";

    /**
     * DAM properties
     */
    static final String PN_EXTRACTED = "dam:extracted";
    static final String PN_SHA1 = "dam:sha1";
    static final String DAM_SIZE = "dam:size";
    static final String DAM_ASSET_ID = "dam:assetID";
    static final String DAM_PARENT_ASSET_ID = "dam:parentAssetID";
    static final String DAM_ASSET_RELATIVE_PATH = "dam:relativePath";

    /**
     * versioning
     */
    static final String PN_PARENT_PATH = "cq:parentPath";
    static final String PN_NAME = "cq:name";
    static final String PN_CHILDREN_ORDER = "cq:childrenOrder";
    static final String PN_SIBLING_ORDER = "cq:siblingOrder";
    static final String PN_VERSION_COMMENT = "cq:versionComment";
    static final String PN_VERSION_CREATOR = "cq:versionCreator";

    /**
     * DC properties
     */
    static final String DC_CONTRIBUTOR = "dc:contributor";
    static final String DC_COVERAGE = "dc:coverage";
    static final String DC_CREATOR = "dc:creator";
    static final String DC_DATE = "dc:date";
    static final String DC_DESCRIPTION = "dc:description";
    static final String DC_EXTENT = "dc:extent";
    static final String DC_FORMAT = "dc:format";
    static final String DC_IDENTIFIER = "dc:identifier";
    static final String DC_LANGUAGE = "dc:language";
    static final String DC_MODIFIED = "dc:modified";
    static final String DC_PUBLISHER = "dc:publisher";
    static final String DC_RELATION = "dc:relation";
    static final String DC_RIGHTS = "dc:rights";
    static final String DC_SUBJECT = "dc:subject";
    static final String DC_TITLE = "dc:title";
    static final String DC_TYPE = "dc:type";

    /**
     * Prefixes
     */
    static final String PREFIX_ASSET_THUMBNAIL = "cq5dam.thumbnail";
    static final String PREFIX_ASSET_WEB = "cq5dam.web";
    static final String PREFIX_ASSET_FPO = "cq5dam.fpo";

    /**
     * EXIF properties
     */
    static final String EXIF_PIXELXDIMENSION = "exif:PixelXDimension";
    static final String EXIF_PIXELYDIMENSION = "exif:PixelYDimension";

    /**
     * TIFF properties
     */
    static final String TIFF_IMAGELENGTH = "tiff:ImageLength";
    static final String TIFF_IMAGEWIDTH = "tiff:ImageWidth";

    /**
     * replication
     */
    static final String PN_PAGE_LAST_REPLICATED = "cq:lastReplicated";
    static final String PN_PAGE_LAST_REPLICATED_BY = "cq:lastReplicatedBy";
    static final String PN_PAGE_LAST_REPLICATION_ACTION = "cq:lastReplicationAction";
    
    /**
     *  onTime/offTime for asset deactiation/activation
     */
    static final String PN_ON_TIME = "onTime";
    static final String PN_OFF_TIME = "offTime";

    /**
     * @deprecated use {@link #DC_TITLE} instead
     */
    @Deprecated
    static final String PN_TITLE = DC_TITLE;

    /**
     * @deprecated use {@link #NT_DAM_ASSET} instead
     */
    @Deprecated
    static final String DAM_ASSET_NT = NT_DAM_ASSET;

    /**
     * The activity stream name for DAM events
     */
    static final String STREAM_NAME_DAM = "dam";

    static final String ACTIVITY_TYPE_ASSET = "asset";
    static final String ACTIVITY_TYPE_EXTERNAL_SYSTEM = "externalSystem";
    static final String ACTIVITY_TYPE_LICENSE = "license";
    static final String ACTIVITY_TYPE_METADATA = "metadata";
    static final String ACTIVITY_TYPE_RENDITION = "rendition";
    static final String ACTIVITY_TYPE_SUBASSET = "subasset";
    static final String ACTIVITY_TYPE_ASSET_EXPIRED = "assetExpired";
    static final String ACTIVITY_TYPE_ASSET_EXPIRING = "assetExpiring";
    
    /**
     * The property name to keep the time of last asset expiration notification service run. It will
     * be updated with current date after each service notification. Notifications will be sent for
     * all assets which are getting expired between LAST_EXPIRY_NOTIFICATION_PROPNAME and current
     * date.
     */
    static String LAST_EXPIRY_NOTIFICATION_PROPNAME = "dam:lastPostExpirationRun";
    
    static final String COLLECTION_SLING_RES_TYPE = "dam/collection";

    static final String SMART_COLLECTION_SLING_RES_TYPE = "dam/smartcollection";
    
    static final String SCHEMA_EDITOR_FORMS_BASE_DIR = "dam/content/schemaeditors/forms";

    static final String PROCESSING_PROFILE = "processingProfile";
    static final String METADATA_PROFILE = "metadataProfile";
    static final String VIDEO_PROFILE = "videoProfile";
    static final String IMAGE_PROFILE = "imageProfile";
    static final String BATCH_SET_PRESETS = "batchSetPreset";

    static final String POST_PROCESS_WF = "postProcessWF";
    static final String POST_PROCESS_WF_TITLE = "postProcessWFTitle";


    static final String THUMBNAIL_NODE = "folderThumbnail";
    
    static final String DOWNLOAD_URL = "downloadUrl";

    /**
     * Property names of jcr:content/metadata -
     * Variable names for the properties are taken from com.day.cq.dam.pim.impl.util.PIMConstants
     * More can be added here for future reference
     */
    static final String ASSET_STATUS_PROPERTY = "dam:status" ;
    /**
     * Metadata property values used in the properties listed above
     */
    static final String ASSET_STATUS_APPROVED = "approved" ;
    static final String ASSET_STATUS_PENDING = "pending" ;
    static final String ASSET_STATUS_REJECTED = "rejected" ;
    static final String RELATION_ASSET_PAGES = "pages";
    
    /**
     * WEBDAV constants
     */
    static final String WEBDAV_TMP_DAM_ROOT = "/tmp/content/dam";
    static final String WEBDAV_SERVICE_USER = "webdavbkpservice";

    static final String PREDICTED_TAGS = JcrConstants.JCR_CONTENT + "/" + METADATA_FOLDER + "/" + "predictedTags";

    /**
     * AFAIU, this ought to be in com.day.cq.dam.api.Asset, but I guess that change has a big impact. Also, I think
     * correct usage of DamConstants class is for generic constants, and not for properties and values for
     * specific nodes.
     */
    /* DAM asset state property */
    static final String DAM_ASSET_STATE = "dam:assetState";
    /* Values for above DAM asset state property */
    static final String DAM_ASSET_STATE_UNPROCESSED = "unProcessed";
    static final String DAM_ASSET_STATE_PROCESSING = "processing";
    static final String DAM_ASSET_STATE_CUSTOM_WORKFLOW_PROCESSING = "customWorkflowProcessing";
    static final String DAM_ASSET_STATE_NEW = "new";
    static final String DAM_ASSET_STATE_PROCESSED = "processed";

    /* DAM asset rendition status property */
    static final String DAM_ASSET_RENDITION_STATUS= "dam:assetRenditionStatus";
    static final String DAM_ASSET_RENDITION_FAILED= "failed";

    /**
     * DAM property defining if an InDesign Snippet is a snippet template.
     */
    static final String DAM_INDESIGN_IS_SNIPPET_TEMPLATE = "dam:isSnippetTemplate";

    /**
     * DAM property to identify if asset is duplicate of other asset(s).
     */
    static final String DAM_IS_DUPLICATE_ASSET = "dam:isDuplicateAsset";

    /**
     * DAM property for identifying the Asset Solution Context
     */
    static final String DAM_SOLUTION_CONTEXT = "dam:solutionContext";

    /**
     * DAM Nui renditions
     */

    static final String NUI_METADATA_RENDITION_NAME = "cqdam.metadata.xml";
    static final String NUI_TEXT_RENDITION_NAME = "cqdam.text.txt";

}
