/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.video;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.RenditionPicker;
import org.apache.commons.lang.StringUtils;

import java.util.Iterator;

/**
 * Rendition picker that 'picks' one according to the given S7 preset handle.
 */
public class Scene7PresetRenditionPicker implements RenditionPicker {

    private String presetHandle = "";

    public Scene7PresetRenditionPicker(String presetHandle) {
        this.presetHandle = presetHandle;
    }

    public Rendition getRendition(Asset asset) {
        final Iterator<Rendition> renditions = asset.listRenditions();
        while (renditions.hasNext()) {
            final Rendition rendition = renditions.next();
            String renditionPresetId = rendition.getProperties().get("scene7.presetHandle", "");
            String searchRenditionId = getPresetIdFromPresetHandle(presetHandle);

            if (StringUtils.isNotBlank(renditionPresetId) && searchRenditionId.equals(renditionPresetId)) {
                return rendition;
            }
        }
        return null;
    }

    /**
     * Extracts the preset id from the preset handle.
     * <p/>
     * Sample preset handle = ps|123456. The extracted preset id would then be 123456
     */
    private String getPresetIdFromPresetHandle(String presetHandle) {
        String presetId = "";
        if (StringUtils.isNotBlank(presetHandle)) {
            presetId = presetHandle.replace("ps|", "");
        }
        return presetId;
    }
}