/*
 * Copyright 1997-2011 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.personalization.tags;

import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.wcm.api.WCMMode;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.scripting.jsp.util.TagUtil;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import java.io.IOException;

/**
 * Implements the <code>&lt;personalisation:contextProfileProperty/&gt;</code> tag
 * AdobePatentID="B1393"
 */
public class ContextProfileHtmlInputTag extends TagSupport {

    private static final long serialVersionUID = 4646561799994266940L;

    private String propertyName;
    @SuppressWarnings("unused")
    private String store;

    //html attributes
    private String id;
    private String clazz;
    private String type;
    private String name;

    @Override
    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        propertyName = null;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setStore(String store) {
        this.store = store;
    }

    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public int doEndTag() throws JspException {
        final JspWriter out = pageContext.getOut();
        final SlingHttpServletRequest request = TagUtil.getRequest(pageContext);
        try {
            out.println(getScript(request, request.adaptTo(UserProperties.class)));

        } catch (IOException e) {
            throw new JspException("Could not write script for context profile property", e);
        }

        return EVAL_PAGE;
    }

    String getScript(SlingHttpServletRequest request, UserProperties userProperties) {
        SlingBindings bindings = (SlingBindings) request.getAttribute(SlingBindings.class.getName());
        XSSAPI xssAPI = bindings.getSling().getService(XSSAPI.class).getRequestSpecificAPI(request);

        StringBuilder res = new StringBuilder();
        boolean isDisabled = WCMMode.fromRequest(request).equals(WCMMode.DISABLED);
        res.append("<input");
        res.append(" id=\"").append(xssAPI.encodeForHTMLAttr(id)).append("\"");
        res.append(" class=\"").append(xssAPI.encodeForHTMLAttr(clazz)).append("\"");
        res.append(" type=\"").append(xssAPI.encodeForHTMLAttr(type)).append("\"");
        res.append(" name=\"").append(xssAPI.encodeForHTMLAttr(name)).append("\"");
        res.append("/>");

        //change field upon ccm changes in author mode, listening for store 'update' events
        if (!isDisabled) {
            res.append("<script type=\"text/javascript\">");
            res.append("if( window.CQ_Analytics && CQ_Analytics.CCM) {");
            res.append("$CQ(function() {");
            res.append("var store = CQ_Analytics.CCM.getRegisteredStore(CQ_Analytics.ProfileDataMgr.STORENAME);");
            res.append("if(store) {");
            res.append("var name = store.getProperty('").append(xssAPI.encodeForJSString(propertyName)).append("', true) || '';");
            res.append("var el = document.getElementById('").append(xssAPI.encodeForJSString(id)).append("');");
            res.append("if( el) {");
            res.append("el.value = name;");
            res.append("}");
            res.append("}");
            res.append("CQ_Analytics.CCM.onReady(function() {");
            res.append("var store = CQ_Analytics.CCM.getRegisteredStore(CQ_Analytics.ProfileDataMgr.STORENAME);");
            res.append("if(store && store.addListener) {");
            res.append("var name = store.getProperty('").append(xssAPI.encodeForJSString(propertyName)).append("', true) || '';");
            res.append("var el = document.getElementById('").append(xssAPI.encodeForJSString(id)).append("');");
            res.append("if( el) {");
            res.append("el.value = name;");
            res.append("}");
            res.append("store.addListener('update', function() {");
            res.append("var name = store.getProperty('").append(xssAPI.encodeForJSString(propertyName)).append("', true) || '';");
            res.append("var el = document.getElementById('").append(xssAPI.encodeForJSString(id)).append("');");
            res.append("if( el) {");
            res.append("el.value = name;");
            res.append("}");
            res.append("});");
            res.append("}");
            res.append("});");
            res.append("});");
            res.append("}");
            res.append("</script>");
        }
        //slightly different here, because there is no store 'update' event
        else {
            res.append("<script type=\"text/javascript\">");
            res.append("if( window.CQ_Analytics && CQ_Analytics.CCM) {");
            res.append("$CQ(function() {");
            res.append("var store = CQ_Analytics.CCM.getRegisteredStore(CQ_Analytics.ProfileDataMgr.STORENAME);");
            res.append("if(store) {");
            res.append("var name = store.getProperty('").append(xssAPI.encodeForJSString(propertyName)).append("', true) || '';");
            res.append("var el = document.getElementById('").append(xssAPI.encodeForJSString(id)).append("');");
            res.append("if( el) {");
            res.append("el.value = name;");
            res.append("}");
            res.append("}");
            res.append("CQ_Analytics.CCM.onReady(function() {");
            res.append("var store = CQ_Analytics.CCM.getRegisteredStore(CQ_Analytics.ProfileDataMgr.STORENAME);");
            res.append("if(store) {");
            res.append("var name = store.getProperty('").append(xssAPI.encodeForJSString(propertyName)).append("', true) || '';");
            res.append("var el = document.getElementById('").append(xssAPI.encodeForJSString(id)).append("');");
            res.append("if( el) {");
            res.append("el.value = name;");
            res.append("}");
            res.append("}");
            res.append("});");
            res.append("});");
            res.append("}");
            res.append("</script>");
        }

        return res.toString();
    }
}
