/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2011 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/

package com.day.cq.replication;


/**
 * The <code>Preprocessor</code> is a service that is called
 * directly before the replication is started. All the checks
 * (permissions etc.) are already performed at this state.
 */
public interface Preprocessor {

    /**
     * Prepare a replication.
     * The processor is allowed to modify the content before
     * the replication like creating a version etc.
     * @param action The replication action
     * @param options The options
     * @throws ReplicationException thrown in case of failure
     */
    void preprocess(final ReplicationAction action,
                    final ReplicationOptions options)
    throws ReplicationException;
}
