/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 * **************************************************************************/

package com.day.cq.wcm.command.api;

import com.adobe.cq.dam.cfm.extensions.ContentFragmentReferenceResolver;
import com.adobe.cq.wcm.launches.cf.ContentFragmentLaunchManager;
import com.day.cq.commons.predicates.PredicateProvider;
import com.day.cq.dam.api.AssetReferenceResolver;
import com.day.cq.i18n.I18n;
import com.day.cq.replication.Replicator;
import com.day.cq.wcm.api.PageManager;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.annotation.versioning.ProviderType;
import org.osgi.service.event.EventAdmin;

/**
 * builder interface for the delete command
 */
@ProviderType
public interface DeleteCommandBuilder extends CommandBuilder {

    /**
     * initializes the {@code ResourceResolver} for the command builder
     *
     * @param resourceResolver the resource resolver for the command builder
     * @return this {@code DeleteCommandBuilder}
     */
    @Nonnull
    DeleteCommandBuilder withResourceResolver(@Nonnull ResourceResolver resourceResolver);

    /**
     * initializes the  {@code PageManager} which provides methods for page level operations
     *
     * @return this {@code DeleteCommandBuilder}
     */
    @Nonnull
    DeleteCommandBuilder withPageManager(@Nonnull PageManager pageManager);

    /**
     * initializes the {@code I18n} object for the command builder
     *
     * @param i18n the internationalization object for the command builder
     * @return this {@code DeleteCommandBuilder}
     */
    @Nonnull
    DeleteCommandBuilder withI18N(@Nonnull I18n i18n);

    /**
     * initializes the {@code Replicator} for the command builder
     *
     * @param replicator the replicator for the command builder
     * @return this {@code DeleteCommandBuilder}
     */
    @Nonnull
    DeleteCommandBuilder withReplicator(@Nonnull Replicator replicator);

    /**
     * initializes the {@code EventAdmin} for the command builder
     *
     * @param eventAdmin the {@code EventAdmin} for the command builder
     * @return this {@code DeleteCommandBuilder}
     */
    @Nonnull
    DeleteCommandBuilder withEventAdmin(@Nonnull EventAdmin eventAdmin);

    /**
     * sets the reference resolver to access references
     *
     * @param assetRefResolver the {@code AssetReferenceResolver} to get references
     * @return this {@code DeleteCommandBuilder}
     */
    @Nonnull
    DeleteCommandBuilder withAssetReferenceResolver(@Nonnull AssetReferenceResolver assetRefResolver);

    /**
     * sets the reference resolver to access references for content fragments
     *
     * @param contentFragmentRefResolver the {@code ContentFragmentReferenceResolver} to get references
     * @return this {@code DeleteCommandBuilder}
     */
    @Nonnull
    DeleteCommandBuilder withContentFragmentReferenceResolver(@Nonnull ContentFragmentReferenceResolver contentFragmentRefResolver);

    /**
     * sets the content fragment launch manager to perform operations
     *
     * @param contentFragmentLaunchManager the {@code ContentFragmentLaunchManager} to launch content fragment operations
     * @return this {@code DeleteCommandBuilder}
     */
    DeleteCommandBuilder withContentFragmentLaunchManager(@Nonnull ContentFragmentLaunchManager contentFragmentLaunchManager);

    /**
     * initializes the {@code PredicateProvider} for the command builder
     *
     * @param predicateProvider the predicate provider for the command builder
     * @return this {@code DeleteCommandBuilder}
     */
    @Nonnull
    @Deprecated
    DeleteCommandBuilder withPredicateProvider(@Nonnull com.day.cq.commons.predicate.PredicateProvider predicateProvider);

    /**
     * initializes the {@code com.day.cq.commons.predicates.PredicateProvider} for the command builder
     *
     * @param predicateProvider the predicate provider for the command builder
     * @return this {@code DeleteCommandBuilder}
     */
    @Nonnull
    DeleteCommandBuilder withPredicateProvider(@Nonnull PredicateProvider predicateProvider);

    /**
     * set whitelist of root paths where deletion is allowed
     *
     * @param deleteWhitelistRootPaths list of root paths under which deletion is allowed
     * @return this {@code DeleteCommandBuilder}
     */
    @Nonnull
    DeleteCommandBuilder withDeleteWhitelistRootPaths(@Nonnull String[] deleteWhitelistRootPaths);

    /**
     * sets whether to perform a shallow operation
     *
     * @param shallow if {@code true} only the content of the resource is deleted
     *        but not its child resources. only supported for pages. default is false
     * @return this {@code DeleteCommandBuilder}
     */
    @Nonnull
    DeleteCommandBuilder withShallow(boolean shallow);

    /**
     * sets whether to do to force delete
     *
     * @param force if {@code false} deletion is executed only if selected item(s)
     * <ul>
     * <li> are not referenced by any pages </li>
     * <li> don't have any child pages (if {@code checkChildren} below is true) </li>
     * <li> don't contain any activated assets </li>
     * </ul>
     * default is false
     * @return this {@code DeleteCommandBuilder}
     */
    @Nonnull
    DeleteCommandBuilder withForce(boolean force);

    /**
     * sets whether to archive resource before delete
     *
     * @param archive if {@code true} version will be created for item(s) and its children selected for deletion.
     * @return this {@code DeleteCommandBuilder}
     */
    @Nonnull
    DeleteCommandBuilder withArchive(boolean archive);

    /**
     * sets whether to check for child pages of selected items while deletion
     *
     * @param checkChildren if {@code true}, and if {@code force} above is false, deletion
     *                      isn't performed if selected items have child pages. default is false
     * @return this {@code DeleteCommandBuilder}
     */
    @Nonnull
    DeleteCommandBuilder withCheckChildren(boolean checkChildren);

    /**
     * @return a new path argument builder
     */
    @Nonnull
    DeleteCommandPathArgumentBuilder createPathArgumentBuilder();

    /**
     * append a path argument
     *
     * @param pathArgument the path argument instance
     * @return this {@code DeleteCommandBuilder}
     */
    @Nonnull
    DeleteCommandBuilder withPathArgument(@Nonnull DeleteCommandPathArgument pathArgument);

}
