/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 1997 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.day.crx.io;

import java.io.IOException;
import java.io.OutputStream;

import javax.jcr.RepositoryException;

/**
 * This Interface defines...
 */
public interface CRXExportHandler {

    void export(String absPath, OutputStream out)
            throws RepositoryException, IOException;

    void setProperty(String name, String value);

    String getProperty(String name);

    boolean getProperty(String name, boolean def);

    boolean isIncludeNeighborhood();

    void setIncludeNeighborhood(boolean includeNeighborhood);

    boolean isExcludeNodeTypes();

    void setExcludeNodeTypes(boolean excludeNodeTypes);

    void setIncludeUUIDs(boolean includeUUIDs);

    boolean isIncludeUUIDs();

    void addExcludedPath(String path);
}
