/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

/**
 *  This {@code Blob} implementations is based on an array of bytes.
 *
 * @deprecated The Jackrabbit Oak Memory library is designed for Oak-internal use only and thus deprecated. It will not be part of the AEM SDK after October 2025.
 */
@Deprecated(since = "2025-04-15")
public class ArrayBasedBlob extends AbstractBlob {

    private final byte[] value;

    public ArrayBasedBlob(byte[] value) {
        this.value = value;
    }

    @NotNull
    @Override
    public InputStream getNewStream() {
        return new ByteArrayInputStream(value);
    }

    @Override
    public long length() {
        return value.length;
    }
}
