/*******************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 * Copyright 2019 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/

package com.adobe.cq.adobeims.imsprofile;

import java.util.Objects;

/**
 * Represents the key for an IMS profile request.
 * It consists of
 * the id/service-pid of the IMS config,
 * the name of the IMS config
 * and the name of the cloud service.
 */
public class ImsProfileKey {

    public ImsProfileKey(String imsConfigServicePid, String imsConfigName, String cloudServiceName) {
        this.imsConfigServicePid  = imsConfigServicePid;
        this.imsConfigName = imsConfigName;
        this.cloudServiceName = cloudServiceName;
    }

    private final String imsConfigServicePid ;

    private final String imsConfigName;

    private final String cloudServiceName;

    public String getImsConfigServicePid() {
        return imsConfigServicePid;
    }

    public String getImsConfigName() {
        return imsConfigName;
    }

    public String getCloudServiceName() {
        return cloudServiceName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ImsProfileKey imsProfileCacheKey = (ImsProfileKey) o;
        return imsConfigServicePid.equals(imsProfileCacheKey.imsConfigServicePid)
                && imsConfigName.equals(imsProfileCacheKey.imsConfigName)
                && cloudServiceName.equals(imsProfileCacheKey.cloudServiceName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(imsConfigServicePid, imsConfigName, cloudServiceName);
    }

    @Override
    public String toString() {
        return "ImsProfileKey{" + "imsConfigServicePid='" + imsConfigServicePid + '\'' + "imsConfigName='" + imsConfigName + '\''
                + ", cloudServiceName='" + cloudServiceName + '\'' + '}';
    }
}
