/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2015 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/

/**
 * <p>Defines the basic API for creating and managing Content Fragments.</p>
 *
 * <p>Main purpose of this API is to abstract the corresponding content structure and
 * to provide convenience methods to manage a fragment.</p>
 *
 * <p>It is important to understand that this API supports two substantially different
 * types of Content Fragments:</p>
 *
 * <ul>
 *   <li><b>Template-based fragments</b> were the first incarnation of
 *     Content Fragments. Their structure is defined by a template, the elements are
 *     supporting textual content only. Changes in the template that was used for creating
 *     a fragment are not reflected in existing fragments.</li>
 *   <li><b>Model-based fragments</b> were the next step in the evolution. Their structure
 *     is defined by a model that allows to define typed elements (or fields). Changes in
 *     models are propagated to all existing fragments sharing the updated model.</li>
 * </ul>
 *
 * <p>Due to that evolution, some of the names in the API might be confusing to users that
 * only know model-based fragments.</p>
 *
 * <p>For example, both models and templates are represented by implementations of
 * {@link com.adobe.cq.dam.cfm.FragmentTemplate}, although the name of the interface might
 * suggest otherwise.</p>
 *
 * <p>This also means that the actual type of a fragment is transparent to the user of the
 * API. Type-based operations are converted back and forth to plain {@link String}s for
 * template-based Content Fragments (as they are only supporting textual content).</p>
 *
 * <h3>Elements</h3>
 *
 * <ul>
 *   <li>A content fragment is represented by an instance of
 *     {@link com.adobe.cq.dam.cfm.ContentFragment}.</li>
 *   <li>Each fragment contains content elements. Elements carry semantically
 *     distinctive parts of the fragment (e.g. a title and content elements of a
 *     typical news article, like a slug line, the article itself, or a desired publication
 *     date).</li>
 *   <li>Each element can have multiple variations of its content. This can be used for
 *     creating longer or shorter versions of the text, depending on the context. For
 *     example, a shorter version may be provided for creating a Twitter-optimized version
 *     of the content.</li>
 * </ul>
 *
 * <p>Each template-based content fragment must have at least one element, but can consist
 * of multiple elements. Model-based fragments can also have zero elements. Variations are
 * completely optional for both types.</p>
 *
 * <p>Content is managed both on the element and the variation level. This means: To access
 * an element's text, first retrieve the element, then use the respective methods to access
 * its content.</p>
 *
 * <h3>Typed data</h3>
 *
 * <p>Model-based fragments introduced the notion of typed data: Each element (or field)
 * has a certain data type assigned to it. If necessary, data is coerced into the
 * appropriate format, e.g. the {@code String} {@code "2"} is coerced into the
 * {@code Integer} {@code 2} for non-fractional numeric fields.</p>
 *
 * <p>Typed data is also supported in a basic way for template-based fragments - internally,
 * all data is stored as text, but if the value is accessed through the
 * {@link com.adobe.cq.dam.cfm.FragmentData} interface, the types will be coerced if
 * necessary.</p>
 *
 * <p>Due to these historical differences, all objects that are used to access the content
 * of a fragment have two different ways to access it:</p>
 *
 * <ul>
 *   <li>{@code getContent()}/{@code setContent()} to access the respective content based on
 *     text (aka {@code String}s)</li>
 *   <li>{@code getValue()}/{@code setValue()} to access the same content in a type-aware
 *     manner</li>
 * </ul>
 *
 * <p>It's recommended to use {@code getValue()}/{@code setValue()} whenever possible,
 *   although nothing prevents one to use the other approach or even combine both.
 *   {@code getContent()}/{@code setContent()} is not supposed to support each single
 *   use-case the type-aware approach supports and might reject some usages by throwing a
 *   {@link com.adobe.cq.dam.cfm.ContentFragmentException}.</p>
 *
 * <h3>Usage patterns</h3>
 *
 * <p>To create a {@link com.adobe.cq.dam.cfm.ContentFragment} from a Sling resource, simply
 * adapt the resource to {@link com.adobe.cq.dam.cfm.ContentFragment}.</p>
 *
 * <p>After adapting the resource, you can access and manipulate the fragment using the
 * respective methods of the API.</p>
 *
 * <p>Manipulating data through {@code getValue()}{@code setValue()} works as follows:</p>
 *
 * <ol>
 *   <li>Get the {@link com.adobe.cq.dam.cfm.FragmentData} object through the respective
 *     {@link com.adobe.cq.dam.cfm.ContentElement#getValue() element-specific} or
 *     {@link com.adobe.cq.dam.cfm.ContentVariation#getValue() variation-specific}
 *     variation of {@code getValue()}</li>
 *   <li>Manipulate the data through the methods of
 *     {@link com.adobe.cq.dam.cfm.FragmentData FragmentData}</li>
 *   <li>Persist the manipulated data by passing the {@code FragmentData} object to the
 *     corresponding {@code getValue()} method (of the
 *     {@link com.adobe.cq.dam.cfm.ContentElement#setValue(com.adobe.cq.dam.cfm.FragmentData) element}
 *     or the {@link com.adobe.cq.dam.cfm.ContentVariation#setValue(com.adobe.cq.dam.cfm.FragmentData) variation}).
 *     </li>
 * </ol>
 *
 * <p>Note that the API doesn't assume auto-commit. This means that you have to
 * commit the {@code org.apache.sling.api.resource.ResourceResolver} explicitly after
 * manipulating the fragment.</p>
 *
 * <h3>Concurrency</h3>
 *
 * <p>The API is not designed for sharing its objects between multiple threads. Therefore
 * the user has to take care of correct synchronization should the use case require shared
 * access.</p>
 *
 * <h3>References</h3>
 *
 * <p>The {@link com.adobe.cq.dam.cfm.converter} API provides means to create an HTML
 * representation for content that leverages other formats like plain text or Markdown.
 * It also supports converting HTML back to these other formats. Therefore, converting
 * any format into another format is supported by first converting the original format
 * into HTML, then convert the HTML into the target format.</p>
 *
 * <p>The {@link com.adobe.cq.dam.cfm.content} API is leveraged for post-processing the
 * content of a fragment instance, before it eventually gets rendered within a specific
 * context. "Fragment instance" in this case means a single occurrence of the fragment in
 * a page (for example).</p>
 *
 * <h3>Template-based vs. model-based fragments - the details</h3>
 *
 * <p><i>Version 1.1</i> of the API introduces typed data and models, extending the purely
 * text-based fragments, based on templates, of version 1.0.</p>
 *
 * <p>The content structure of both fragment types are different. The API hides these
 * differences from the user. As mentioned before, the actual type of a fragment is
 * transparent to the user of this API.</p>
 *
 * <p>Mapping of certain concepts of model-based fragments to interfaces of this API:</p>
 *
 * <table>
 *   <caption>Links to FragmentTemplate and ElementTemplate</caption>
 *   <thead>
 *     <tr>
 *       <th>Concept</th>
 *       <th>Class</th>
 *     </tr>
 *   </thead>
 *   <tbody>
 *     <tr>
 *       <td>model</td>
 *       <td>{@link com.adobe.cq.dam.cfm.FragmentTemplate}</td>
 *     </tr>
 *     <tr>
 *       <td>field</td>
 *       <td>{@link com.adobe.cq.dam.cfm.ElementTemplate}</td>
 *     </tr>
 *   </tbody>
 * </table>
 */
@Version("1.17.0")
package com.adobe.cq.dam.cfm;

import org.osgi.annotation.versioning.Version;
