package com.adobe.cq.wcm.launches.cf;

import java.util.Calendar;
import org.osgi.annotation.versioning.ProviderType;

/**
 * The RebaseDiffEntry interface provides methods to get information about differences between a launch and its source.
 * This information is used when performing a rebase operation.
 */
@ProviderType
public interface RebaseDiffEntry {

    /**
     * Returns the field name.
     *
     * @return the field name
     */
    String getFieldName();

    /**
     * Returns the value of the field in the launch.
     * @return the value of the field in the launch
     */
    Object getLaunchValue();

    /**
     * Returns the value of the field in the source.
     * @return the value of the field in the source
     */
    Object getSourceValue();

    /**
     * Returns the path of the content fragment in the launch.
     * @return the path of the content fragment in the launch
     */
    String getLaunchContentFragmentPath();

    /**
     * Returns the path of the content fragment in the source.
     * @return the path of the content fragment in the source
     */
    String getSourceContentFragmentPath();

    /**
     * Returns the last modified date of the content fragment in the launch.
     * @return the last modified date of the content fragment in the launch
     */
    Calendar getLaunchLastModifiedDate();

    /**
     * Returns the last modified date of the content fragment in the source.
     * @return the last modified date of the content fragment in the source
     */
    Calendar getSourceLastModifiedDate();

    /**
     * Returns the user who last modified the content fragment in the launch.
     * @return the user who last modified the content fragment in the launch
     */
    String getLaunchLastModifiedBy();

    /**
     * Returns the user who last modified the content fragment in the source.
     * @return the user who last modified the content fragment in the source
     */
    String getSourceLastModifiedBy();

    /**
     * Returns the status of the difference between the launch and the source.
     * @return the status of the difference
     */
    DiffStatus getStatus();

    /**
     * Returns the name of the variation.
     *
     * @return the name of the variation
     */
    String getVariationName();

    /**
     * Returns the last replicated date of the content fragment in the source.
     * @return the last replicated date of the content fragment in the source
     */
    Calendar getSourceLastReplicatedDate();

    /**
     * Returns the user who last replicated the content fragment in the source.
     * @return the user who last replicated the content fragment in the source
     */
    String getSourceLastReplicatedBy();

    /**
     * Returns the last replicated date of the content fragment in the launch.
     * @return the last replicated date of the content fragment in the launch
     */
    Calendar getLaunchLastReplicatedDate();

    /**
     * Returns the user who last replicated the content fragment in the launch.
     * @return the user who last replicated the content fragment in the launch
     */
    String getLaunchLastReplicatedBy();
}
