/*******************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 * Copyright 2016 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/

package com.adobe.cq.xf;

import org.osgi.annotation.versioning.ProviderType;
import com.adobe.granite.references.Reference;
import com.day.cq.wcm.api.Page;

import java.util.List;

/**
 * Service that provides methods to work with the Experience Fragments objects
 */
@ProviderType
public interface ExperienceFragmentsService {

    /**
     * Finds all the experience fragments variations in a given content page.
     *
     * @param page the content page
     * @return a list of variations used in the given page
     */
    List<ExperienceFragmentVariation> listUsedVariations(Page page);

    /**
     * Finds all the pages that use one or more experience fragment variations
     *
     * @param variation one or more {@link ExperienceFragmentVariation} objects
     * @return a list of pages that contain components pointing to those experience fragments variations
     */
    List<Page> listPagesUsingVariation(ExperienceFragmentVariation... variation);

    /**
     * Returns a list of references for an experience fragment at a given path
     *
     * @param experienceFragmentPath the path to the experience fragment. This path must point to the actual experience
     *                               fragment page, not the "jcr:content" node.
     * @param referenceType          an optional reference type which indicates which reference
     *                               provider(s) to use. If this parameter is not supplied then all the references are
     *                               returned
     * @return a list of {@link Reference} object. The "source" of the reference will be the page that uses the experience
     * fragment and the "target" of the reference will be specific variation that the page embeds.
     */
    List<Reference> findReferences(String experienceFragmentPath, String... referenceType);

}
