/*
 * File: FontStyle.java
 * 
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2004-2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */
package com.adobe.fontengine.inlineformatting;

/** Enumerated values for {@link ElementAttribute#fontStyle}.
 */
final public class FontStyle {
  private final String name;
  
  private FontStyle (String name) {
    this.name = name;
  }
  
  public String toString () {
    return name;
  }
  
  public static final FontStyle NORMAL = new FontStyle ("NORMAL"); 
  public static final FontStyle ITALIC = new FontStyle ("ITALIC");
  public static final FontStyle OBLIQUE = new FontStyle ("OBLIQUE");

  private static final FontStyle[] allValues 
    = {NORMAL, ITALIC, OBLIQUE};
  
  public static FontStyle parse (String s) {
    for (int i = 0; i < allValues.length; i++) {
      if (allValues [i].name.compareToIgnoreCase (s) == 0) {
        return allValues [i]; }}
    return null;
  }
}