/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2017 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.adobe.granite.auth.ims;

import javax.servlet.http.HttpServletRequest;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The <code>IMSConfigProvider</code> provides a configuration aggregating the IMS Provider config. and
 * IMS OAuth config. for the configured <code>configid</code>.
 *
 * This class listens for changes in those config and stores a unified configuration with
 * PID = <code>com.adobe.granite.auth.ims</code>.
 */
@ProviderType
public interface ImsConfigProvider {

    /**
     * @return the relative URL that will start an IMS login flow
     * associated with the configured <code>configid</code> or
     * {@code null} if the configuration doesn't exist
     */
    public String getImsLoginUrl();

    /**
     * @param request The request containing the information to be
     * extracted in order to form the complete redirect_uri.
     * The additional information are extracted from the 'resource'
     * request parameter and the request context path
     *
     * @return the relative URL that will start an IMS login flow
     * associated with the configured <code>configid</code> or
     * {@code null} if the configuration doesn't exist
     *
     * @since 1.1.0
     */
    public String getImsLoginUrl(HttpServletRequest request);
    
    /**
     * @return the current configured IMS Instance
     * @since 1.3.0
     */
    public IMSInstance currentIMSInstance();
}
