/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2022 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.adobe.granite.replication.treeactivation;

import java.util.Arrays;
import java.util.List;

import lombok.Builder;
import lombok.Builder.Default;
import lombok.EqualsAndHashCode;
import lombok.NonNull;
import lombok.Value;

@Value
@Builder
@EqualsAndHashCode
public class ActivationParameters {
    public static final String DEFAULT_AGENT_ID = "publish";
    public static final int DEFAULT_MAX_TREE_SIZE = 200000;
    public static final int DEFAULT_CHUNK_SIZE = 100;
    public static final int DEFAULT_MAX_QUEUE_SIZE = 1000;
    public static final int DEFAULT_MAX_LEVEL = 3;
    
    private String rootPath;
    
    private String activationid;
    
    @NonNull
    private String path;
    
    @Default
    private IncludeChildren includeChildren = IncludeChildren.ALL_CHILDREN;
    
    // User id to impersonate when accessing repository and replicating
    @NonNull
    private String userId;
    
    // List of filter names
    @Builder.Default
    private List<String> filters = Arrays.asList();
    
    private String refServiceName;
    
    @Builder.Default
    private String agentId = DEFAULT_AGENT_ID;
    
    @Builder.Default
    private int chunkSize = DEFAULT_CHUNK_SIZE;
    
    @Builder.Default
    private int maxTreeSize = DEFAULT_MAX_TREE_SIZE;
    
    @Builder.Default
    private int maxLevel = DEFAULT_MAX_LEVEL;

    @Builder.Default
    private int maxQueueSize = DEFAULT_MAX_QUEUE_SIZE;
    
    @Builder.Default
    private boolean enableVersion = false;
    
    @Builder.Default
    private boolean dryRun = false;
    
}
