/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2011 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/

package com.adobe.granite.translation.connector.msft.core;

import com.adobe.granite.translation.api.TranslationException;
import org.apache.http.impl.client.CloseableHttpClient;

public interface AccessToken {

    public String getAccessTokenString(CloseableHttpClient client) throws TranslationException;

    public long getTokenExpiredTime();

    public int getTimeOffset();

    public void setTimeOffset(int offset);

    public int getStatusCode();

    // The getter and setter methods for auth_url, grant_type and scope.
    // I implemented these methods in case MS will change/upgrade the service path or parameter values in the future.
    public String getAuthURL();

    public void setAuthURL(String url);

    // Don't provide the getter methods for client information as they are confidential.
    // The user of access token MUST know these client information.
    public void setSubscriptionKey(String key);
}
