/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.ui.tags;

import java.io.IOException;

import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.scripting.jsp.util.TagUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.adobe.granite.ui.clientlibs.HtmlLibraryManager;

/**
 * Implements the <code>&lt;ui:includeClientLib/&gt;</code> tag, a convenience
 * wrapper for the {@link HtmlLibraryManager} service.
 */
public class IncludeClientLibraryTag extends TagSupport {
    
    private static final long serialVersionUID = -3068291967085012331L;

    private static final Logger log = LoggerFactory.getLogger(IncludeClientLibraryTag.class);

    private String categories;
    private String js;
    private String css;
    private String theme;
    private Boolean themed;

    @Override
    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        categories = null;
        js = null;
        css = null;
        theme = null;
        themed = null;
    }

    public void setCategories(String categories) {
        this.categories = categories;
    }
    
    public void setJs(String js) {
        this.js = js;
    }
    
    public void setCss(String css) {
        this.css = css;
    }
    
    public void setTheme(String theme) {
        this.theme = theme;
    }
    
    public void setThemed(boolean themed) {
        this.themed = themed;
    }

    @Override
    public int doEndTag() throws JspException {
        final SlingHttpServletRequest request = TagUtil.getRequest(pageContext);
        
        final HtmlLibraryManager libManager = getHtmlLibraryManager(request);
        if (libManager == null) {
            log.warn("<ui:includeClientLib>: Could not retrieve HtmlLibraryManager service, skipping inclusion.");
            return EVAL_PAGE;
        }
        
        final JspWriter out = pageContext.getOut();
        
        try {
            if (categories != null) {
                libManager.writeIncludes(request, out, toArray(categories));
                
            } else if (theme != null) {
                libManager.writeThemeInclude(request, out, toArray(theme));
                
            } else if (js != null) {
                if (themed != null) {
                    libManager.writeJsInclude(request, out, themed, toArray(js));
                } else {
                    libManager.writeJsInclude(request, out, toArray(js));
                }
                
            } else if (css != null) {
                if (themed != null) {
                    libManager.writeCssInclude(request, out, themed, toArray(css));
                } else {
                    libManager.writeCssInclude(request, out, toArray(css));
                }
            }
            
        } catch (IOException e) {
            String libs = categories != null ? "categories: " + categories
                                : theme != null ? "theme: " + theme
                                        : js != null ? "js: " + js
                                                : css != null ? "css: " + css : ""; 
            throw new JspException("Could not include client library: " + libs, e);
        }
        
        return EVAL_PAGE;
    }

    private HtmlLibraryManager getHtmlLibraryManager(ServletRequest request) {
        SlingBindings bindings = (SlingBindings) request.getAttribute(SlingBindings.class.getName());
        return bindings.getSling().getService(HtmlLibraryManager.class);
    }
    
    private static String[] toArray(String commaSeparatedList) {
        if (commaSeparatedList == null) {
            return new String[] {};
        }
        String[] split = commaSeparatedList.split(",");
        for (int i = 0; i < split.length; i++) {
            split[i] = split[i].trim();
        }
        return split;
    }
}
