/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.workflow.collection.util;

import com.adobe.granite.workflow.WorkflowSession;

/**
 * Interface for a set of workflow entities that can be retrieved via
 * <code>{@link WorkflowSession}</code>.
 */
public interface ResultSet<T> {
    /**
     * Returns the items contained in this result set.
     * 
     * @return The items contained in this result set.
     */
    T[] getItems();

    /**
     * Returns the total number of results available.
     * 
     * @return The total number of results available.
     */
    long getTotalSize();
}
