/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.workflow.exec;

import java.util.Date;

/**
 * Contains information about the history of a <code>{@link Workflow}</code>.
 *
 * @see com.adobe.granite.workflow.WorkflowSession#getHistory(Workflow)
 */
public interface HistoryItem {
    /**
     * The history comment (entered while advancing, starting, terminating)
     *
     * @return comment
     */
    String getComment();

    /**
     * The action that got issued on the <code>{@link com.adobe.granite.workflow.exec.WorkItem}</code>
     *
     * @return action descriptor as string
     */
    String getAction();

    /**
     * Date when an action <code>{@link com.adobe.granite.workflow.exec.WorkItem}</code>
     * got issued that caused this <code>HistoryItem</code>
     *
     * @return date
     */
    Date getDate();

    /**
     * User who triggered the  action <code>{@link com.adobe.granite.workflow.exec.WorkItem}</code>
     * hat caused this <code>HistoryItem</code>
     *
     * @return the user id
     */
    String getUserId();

    /**
     * Returns the previous history item.
     *
     * @return the previous {@link HistoryItem}
     *         if available otherwise <code>null</code>
     */
    HistoryItem getPreviousHistoryItem();

    /**
     * Returns the next history item.
     *
     * @return the next {@link HistoryItem}
     *         if available otherwise <code>null</code>
     */
    HistoryItem getNextHistryItem();

    /**
     * Returns the corresponding {@link WorkItem}
     *
     * @return {@link WorkItem}
     */
    WorkItem getWorkItem();
}
