/**
 * 
 */
package com.adobe.internal.io;

import java.io.IOException;

/**
 * Filters wrap existing ByteWriters and will do conversion or other data
 * mangling.
 */
public abstract class FilterByteWriter implements ByteWriter
{
	protected ByteWriter out;
	protected boolean closeOriginal = true;
	
	/**
	 * Constructor
	 * @param byteWriter the original source / sink of data
	 */
	protected FilterByteWriter(ByteWriter byteWriter)
	{
		this.out = byteWriter;
	}

	/**
	 * Changes whether the original ByteWriter is closed when this
	 * FilterByteWriter is closed.  By default this is true.
	 * @param closeOriginal close original ByteWriter or not
	 */
	public void setCloseOriginal(boolean closeOriginal)
	{
		this.closeOriginal = closeOriginal;
	}
	
	/* (non-Javadoc)
	 * @see com.adobe.internal.io.ByteWriter#flush()
	 */
	public void flush() throws IOException
	{
		this.out.flush();
	}

	/* (non-Javadoc)
	 * @see com.adobe.internal.io.ByteWriter#write(long, int)
	 */
	public void write(long position, int b) throws IOException
	{
		this.out.write(position, b);
	}

	/* (non-Javadoc)
	 * @see com.adobe.internal.io.ByteWriter#write(long, byte[], int, int)
	 */
	public void write(long position, byte[] b, int offset, int length)
		throws IOException
	{
		this.out.write(position, b, offset, length);
	}

	/* (non-Javadoc)
	 * @see com.adobe.internal.io.ByteReader#close()
	 */
	public void close() throws IOException
	{
		if (this.closeOriginal)
		{
			this.out.close();
		}
	}

	/* (non-Javadoc)
	 * @see com.adobe.internal.io.ByteReader#length()
	 */
	public long length() throws IOException
	{
		return this.out.length();
	}

	/* (non-Javadoc)
	 * @see com.adobe.internal.io.ByteReader#read(long)
	 */
	public int read(long position) throws IOException
	{
		return this.out.read(position);
	}

	/* (non-Javadoc)
	 * @see com.adobe.internal.io.ByteReader#read(long, byte[], int, int)
	 */
	public int read(long position, byte[] b, int offset, int length)
		throws IOException
	{
		return this.out.read(position, b, offset, length);
	}

}
