/* ****************************************************************************
 *
 *	File: CosContainerValuesIterator.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2006 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 * ***************************************************************************/

// @author itenenbo

package com.adobe.internal.pdftoolkit.core.cos;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;

public abstract class CosContainerValuesIterator
{
	/**
	 * 
	 * This class contains CosObject and the key or index at which it is stored
	 * in the parent CosContainer. If the parent CosContainer is CosDictionary 
	 * then the key is not <code>null</code> and index is -1. 
	 * If the parent CosContainer is CosArray then
	 * key is null and index is not negative. 
	 * Entry may contain both key equal <code>null</code>
	 * and index equal -1. This occurs when the parent CosContainer or its type are
	 * not known.
	 */
	static public class Entry
	{
		ASName mKey;
		CosObject mValue;
		int mCurIndex;
		
		public Entry(ASName key, int index, CosObject value)
		{
			mKey = key;
			mCurIndex = index;
			mValue = value;
		}
		
		/**
		 * 
		 * @return Key under which the value of this entry is stored in the parent CosDictionary 
		 */
		public ASName getKey()
		{
			return mKey;
		}
		
		/**
		 * 
		 * @return Index under which the value of this entry is stored in the parent CosArray 
		 */
		public int getIndex()
		{
			return mCurIndex;
		}
		
		/**
		 * 
		 * @return CosObject which is value of this entry
		 */
		public CosObject getValue()
		{
			return mValue;
		}
	}
	
	CosContainerValuesIterator()
	{
		super();
	}
	
	/**
	 *  
	 * Creates new Entry object. @see CosContainerValuesIterator.Entry
	 * @param key May be <code>null</code>
	 * @param ind May be -1
	 * @param value May not be null
	 * @return new Entry object with specified content.
	 */
	public Entry createEntry(ASName key, int ind, CosObject value)
	{
		return new Entry(key, ind, value);
	}

	abstract public boolean hasNext();

	abstract public Entry next()
	throws PDFCosParseException, PDFIOException, PDFSecurityException;

}
