/*
 * File: ByteArrayKeyHolder.java
 *  
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 * ***************************************************************************/

package com.adobe.internal.pdftoolkit.core.credentials.impl;

import com.adobe.internal.pdftoolkit.core.credentials.PrivateKeyHolder;
 
/**
 * The ByteArrayKeyHolder contains the bytes representing the DER encoded PKCS8 unencrypted PrivateKey
 * and the wrapping format of the key - whether it is RSA or DSA.
 * @author mdharan
 *
 */
public class ByteArrayKeyHolder implements PrivateKeyHolder
{
	byte[] derEncodedKey;
	String algorithm;
	
	public ByteArrayKeyHolder(byte[] key,String algorithm) {
		super();
		this.algorithm = algorithm;
		derEncodedKey = key;
	}
	public String getAlgorithm() {
		return algorithm;
	}
	public void setAlgorithm(String algorithm) {
		this.algorithm = algorithm;
	}
	public byte[] getDerEncodedKey() {
		return derEncodedKey;
	}
	public void setDerEncodedKey(byte[] derEncodedKey) {
		this.derEncodedKey = derEncodedKey;
	}
	public PrivateKeyHolder getPrivateKeyHolder() 
	{
		return this;
	}
	
	
	

}
