/* File: HSMPrivateKey.java
*  
* ****************************************************************************
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2006 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
* ***************************************************************************/

package com.adobe.internal.pdftoolkit.core.credentials.impl;

import java.security.PrivateKey;

import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_Session;

/**
 * An implementation of the JCE PrivateKey interface to support HSM signing.
 * @author mdharan
 *
 */
public class HSMPrivateKey implements PrivateKey
{
	JSAFE_PrivateKey jsafeKey;
	JSAFE_Session[] session;

	
	private static final long serialVersionUID = 1L;

	public HSMPrivateKey(JSAFE_PrivateKey key, JSAFE_Session[] session) 
	{
		super();
		this.jsafeKey = key;
		this.session = session;
	}

	/**
	 * Returns null for the HSM private key . 
	 */
	public byte[] getEncoded() {
		return null;
	}

	
	public String getAlgorithm() {
		return jsafeKey.getAlgorithm();
	}

	public String getFormat() {
		return jsafeKey.getKeyWrappingFormat(true);
	}

	/**
	 * Returns the com.rsa.jsafe.JSAFE_PrivateKey that holds private keys for all asymmetric operations
	 * @return com.rsa.jsafe.JSAFE_PrivateKey
	 */
	public JSAFE_PrivateKey getJsafeKey() {
		return jsafeKey;
	}

	/**
	 * Supply the JSAFE_PrivateKey to be used for HSM signing.
	 * @param jsafeKey
	 */
	public void setJsafeKey(JSAFE_PrivateKey jsafeKey) {
		this.jsafeKey = jsafeKey;
	}

	/**
	 * Returns an array of JSAFE Sessions that encapsulate the information needed to open a session with a token in a device
	 * that supports the Cryptoki (PKCS #11) interface.
	 * @return JSAFE_Session[] - array of Jsafe Sessionss that have been established with a token present in a hardware device
	 */
	public JSAFE_Session[] getSession() {
		return session;
	}

	/**
	 * Set the array of JSAFESessions that have been established with a token on the hardware device.
	 * @param session
	 */
	public void setSession(JSAFE_Session[] session) {
		this.session = session;
	}

}
