/*
 *
 *	File: PDFInvalidDocumentException.java
 *
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */
package com.adobe.internal.pdftoolkit.core.exceptions;


/**
 * Indicates a general problem with the PDFDocument that was being 
 * operated on.  At this point the PDFDocument may be in an unknown
 * state.
 */
public class PDFInvalidDocumentException extends PDFException
{
	/**
	 * This is a default serialVersionUID.
	 */
	private static final long serialVersionUID = 1L;

	/**
     * Create a new PDFInvalidDocumentException.
     * @param message the detail message.
     */
    public PDFInvalidDocumentException(String message)
    {
        super(message);
    }

    /**
     * Create a new PDFInvalidDocumentException wrapping an existing exception.
     * @param message the detail message.
     * @param cause the cause.
     */
    public PDFInvalidDocumentException(String message, Throwable cause)
    {
        super(message, cause);
    }

    /**
     * Create a new PDFInvalidDocumentException wrapping an existing exception.
     * @param cause the cause.
     */
    public PDFInvalidDocumentException(Throwable cause)
    {
        super(cause);
    }
}
