/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.reef.siren.converter;

import com.adobe.reef.siren.Entity;

/**
 * {@code Converter} is an interface describing a Java class that can perform
 * Object-to-Entity and Entity-to-Object conversions between model data objects
 * and a Entity representation of those objects that is suitable for rendering.
 */
public interface Converter<T> {

    /**
     * Converts a {@code resource} of type {@code T} into an {@link Entity}.
     * 
     * @param context
     * @param resource
     * @return
     * @throws ConverterException
     */
    Entity toEntity(ConverterContext<T> context, T resource) throws ConverterException;

    /**
     * Converts an {@link Entity} into a resource of type {@code T}.
     * 
     * @param context
     * @param entity
     * @return
     * @throws ConverterException
     */
    T fromEntity(ConverterContext<T> context, Entity entity) throws ConverterException;

}
