/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa;

/**
 * This is a generic class to represent all XFA nodes whose schema allows a single
 * #text child.
 *
 * @exclude from published api.
 */
public final class GenericTextContainer extends ProtoableNode {

	public GenericTextContainer(Element parent, Node prevSibling) {
		super(parent, prevSibling, null, null, null, null, -1, null);
	}

	public Element clone(Element pParent, boolean bDeep) {
		GenericTextContainer oClone = (GenericTextContainer) super.clone(pParent, bDeep);
		oClone.setLocalName(getLocalName());
		return oClone;
	}

	public ScriptTable getScriptTable() {
		return GenericTextContainerScript.getScriptTable();
	}

	public String getValue() {
		TextNode node = (TextNode) getProperty(XFA.TEXTNODETAG, 0);
		String sReturn = "";
		if (node != null)
			sReturn = node.getValue();
		return sReturn;
	}

	void setValue(String sValue) {
		TextNode node = (TextNode) getProperty(XFA.TEXTNODETAG, 0);
		if (node != null)
			node.setValue(sValue,true,false);
	}

}
