/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.content;

import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.XFA;

/**
 * An element that describes a unit of data content representing a date
 * and time conforming to a subset of ISO 8601 format.
 *
 * @exclude from published api.
 */
public final class DateTimeValue extends Content {

	public DateTimeValue(Element parent, Node prevSibling) {
		super(parent, prevSibling, null, XFA.DATETIME, XFA.DATETIME, null,
				XFA.DATETIMETAG, XFA.DATETIME);
	}

	public boolean equals(Object object) {
		
		if (this == object)
			return true;
		
		return super.equals(object) &&
			getValue().equals(((DateTimeValue) object).getValue());
	}
	
	public int hashCode() {
		return super.hashCode() ^ getValue().hashCode(); 
	}

	/**
	 * Return the current date/time value as a String
	 * 
	 * @return the date/time value as a string.
	 */
	public String getValue() {
		return getStrValue();

	}

	public ScriptTable getScriptTable() {
		return DateTimeScript.getScriptTable();
	}

	/**
	 * Set the current date/time value from a String
	 * 
	 * @param dateTimeValue
	 *            date/time value provided as a String
	 */
	public void setValue(String dateTimeValue) {
		setStrValue(dateTimeValue, true, false);
	}

	/**
	 * cast the current value to a String. This operator allows us to place an
	 * DateTimeValueobject in any context which allows a String.
	 * 
	 * @return the date value as a String.
	 */
	public String toString() {
		return getValue();
	}

}
