/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2007 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.data;


//import java.util.List;

import com.adobe.xfa.Arg;
//import com.adobe.xfa.Element;
import com.adobe.xfa.ElementScript;
//import com.adobe.xfa.Node;
//import com.adobe.xfa.NodeList;
import com.adobe.xfa.Obj;
//import com.adobe.xfa.STRS;
import com.adobe.xfa.Schema;
import com.adobe.xfa.ScriptPropObj;
import com.adobe.xfa.ScriptTable;
//import com.adobe.xfa.XFA;
import com.adobe.xfa.ut.BooleanHolder;
//import com.adobe.xfa.ut.Key;


/**
 * This class contains all the script functionality associated with the
 * DataNode class.  Broken out into a separate class for easier maintainability.
 *
 * @exclude from published api.
 */
public class DataNodeScript extends ElementScript {

	protected static final ScriptTable moScriptTable = new ScriptTable(
		ElementScript.moScriptTable,
		"dataValue",
		new ScriptPropObj[] {
			new ScriptPropObj(DataNodeScript.class, "value", "getValue", "setValue", Arg.INVALID, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_DATAVALUE_VALUE, 0 */, 0),
			new ScriptPropObj(DataNodeScript.class, null, "getValue", "setValue", Arg.INVALID, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_DATAVALUE_VALUE, 0 */, 0),
			new ScriptPropObj(DataNodeScript.class, "contains", "getContains", "setContains", Arg.STRING, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_DATAVALUE_CONTAINS, 0 */, 0),
			new ScriptPropObj(DataNodeScript.class, "contentType", "getContentType", "setContentType", Arg.STRING, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_DATAVALUE_CONTENTTYPE, 0 */, 0),
			new ScriptPropObj(DataNodeScript.class, "isNull", "getIsNull", "setIsNull", Arg.BOOL, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_DATAVALUE_ISNULL, 0 */, 0)
		},
		null
	);
	
	public static ScriptTable getScriptTable() {
		return moScriptTable;
	}

	public static void getContains(Obj pObj, Arg oRetVal) {
		oRetVal.setString(((DataNode) pObj).getContains());
	}

	public static void getContentType(Obj pObj, Arg oRetVal) {
		oRetVal.setString(((DataNode) pObj).getContentType());
	}

	public static void getIsNull(Obj pObj, Arg oRetVal) {
		boolean bIsNull = ((DataNode) pObj).getIsNull();
		oRetVal.setBool(Boolean.valueOf(bIsNull));
	}

	public static void getValue(Obj pObj, Arg oRetVal) {
		if ( ! ((DataNode) pObj).getIsNull())
			oRetVal.setString(((DataNode) pObj).getValue());
		else
			oRetVal.setNull();
	}

	public static void setContains(Obj pObj, Arg propertyValue) {
		((DataNode) pObj).setContains(propertyValue.getString());
	}

	public static void setContentType(Obj pObj, Arg propertyValue) {
		((DataNode) pObj).setContentType(propertyValue.getString());
	}

	public static void setIsNull(Obj pObj, Arg propertyValue) {
		((DataNode) pObj).setIsNull(propertyValue.getBool().booleanValue(), true);
	}

	public static void setValue(Obj pObj, Arg propertyValue) {
		((DataNode) pObj).setValue(propertyValue.getString(), true);
	}

	// Portions of this code implement AdobePatentID="1082"
	final static String patentRef = "AdobePatentID=\"B1082\"";	
		
	public static boolean scriptPropResolveAssociation(Obj obj, Arg retVal, String aAssociationName) {
		DataNode dataNode = (DataNode)obj;
		
		BooleanHolder bFoundNullAssociation = new BooleanHolder();		
		Obj ret = DataModel.resolveAssociation(dataNode, aAssociationName, bFoundNullAssociation);
		if (ret != null) {
			retVal.setObject(ret, true);
			return true;
		}
		else if (bFoundNullAssociation.value) {
			retVal.setObject(null, true);
			return true;
		}

		return false;
	}
}
