/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.data;

import com.adobe.xfa.ChildReln;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.STRS;
import com.adobe.xfa.Schema;
import com.adobe.xfa.XFA;

/**
 * The (simple) schema of our XFA Data DOM
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */

public final class DataSchema extends Schema {

	DataSchema() {
		super(STRS.XFADATANS,
				XFA.XFA_ATTRIBUTE_MIN, 
				XFA.XFA_ATTRIBUTE_MAX, 
				XFA.XFA_ELEMENT_MIN, 
				XFA.XFA_ELEMENT_MAX);
		initSchema();
	}


	protected void initSchema() {
		super.initSchema();
		// 
		// populate the schema relationships
		//
		putElement(XFA.DATAVALUETAG, XFA.DATAVALUETAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0);
		putElement(XFA.DATAVALUETAG, XFA.DSIGDATATAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0);
		
		putElement(XFA.DATAGROUPTAG, XFA.DATAVALUETAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0);
		putElement(XFA.DATAGROUPTAG, XFA.DATAGROUPTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0);
		putElement(XFA.DATAGROUPTAG, XFA.DSIGDATATAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0);
		
		putElement(XFA.DATAMODELTAG, XFA.DSIGDATATAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0);
		putElement(XFA.DATAMODELTAG, XFA.DATAGROUPTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0);
		
		//C++ CL:742428
		putElement(XFA.DSIGDATATAG, XFA.DSIGDATATAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0);		
	}


	protected Element newElement(int eTag, Element parent, Node prevSibling) {
		Element e = null;
		switch (eTag) {
		case XFA.DATAVALUETAG:
			e = new com.adobe.xfa.data.DataNode(parent, prevSibling);
			e.setClass(XFA.DATAVALUE, XFA.DATAVALUETAG);
			break;
		case XFA.DATAGROUPTAG:
			e = new com.adobe.xfa.data.DataNode(parent, prevSibling);
			e.setClass(XFA.DATAGROUP, XFA.DATAGROUPTAG);
			break;
		case XFA.DSIGDATATAG:
			e = new com.adobe.xfa.DSigData(parent, prevSibling);
			break;
		default:
			break;
		}
		return e;
	}
}
