/*************************************************************************
 *
 *	File: BarcodeType.java
 *
 **************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.xfa.pmp.common;

/**
 * Represents various barcode types. (Currently Supported: PDF417, DataMatrix, QRCode)
 */
public enum BarcodeType {

	PDF417("PDF417"), QRCode("QRCode"), DataMatrix("DataMatrix");
	private BarcodeType(String type) {
		this.type = type;
	}

	private String type;

	/**
	 * Gets an instance of BarcodeType corresponding to the type supplied
	 * @param type barcode type
	 * @return BarcodeType instance
	 */
	public static BarcodeType getInstance(String type) {
		BarcodeType[] barcodeTypes = BarcodeType.values();
		for (int i = 0; i < barcodeTypes.length; i++) {
			if (barcodeTypes[i].type.equalsIgnoreCase(type)) {
				return barcodeTypes[i];
			}
		}
		return null;
	}

	public String toString() {
		return type;
	}
}
