package com.adobe.xfa.text;

import com.adobe.xfa.ut.UnitSpan;

/**
 * @exclude from published api.
 */

class FrameLineInfo {
	private TextSparseStream mpoStream;
	private int mnFrameIndex;
	private int mnLineIndex;
	private int mnAbsLineIndex;
	private UnitSpan moOffset = UnitSpan.ZERO;

	FrameLineInfo (TextSparseStream poStream, int nFrameIndex, int nLineIndex, int nAbsLineIndex) {
		mpoStream = poStream;
		mnFrameIndex = nFrameIndex;
		mnLineIndex = nLineIndex;
		mnAbsLineIndex = nAbsLineIndex;
	}

	FrameLineInfo (TextSparseStream poStream) {
		this (poStream, 0, 0, 0);
	}

	TextSparseStream getStream () {
		return mpoStream;
	}

	void setStream (TextSparseStream poStream) {
		mpoStream = poStream;
	}

	int getFrameIndex () {
		return mnFrameIndex;
	}

	void setFrameIndex (int nFrameIndex) {
		mnFrameIndex = nFrameIndex;
	}

	int getLineIndex () {
		return mnLineIndex;
	}

	void setLineIndex (int nLineIndex) {
		mnLineIndex = nLineIndex;
	}

	int getAbsLineIndex () {
		return mnAbsLineIndex;
	}

	void setAbsLineIndex (int nAbsLineIndex) {
		mnAbsLineIndex = nAbsLineIndex;
	}

	UnitSpan getOffset () {
		return moOffset;
	}

	void setOffset (UnitSpan oOffset) {
		moOffset = oOffset;
	}

	FrameLineInfo copyFrom (FrameLineInfo oSource) {
		if (this != oSource) {
			mpoStream = oSource.mpoStream;
			mnFrameIndex = oSource.mnFrameIndex;
			mnLineIndex = oSource.mnLineIndex;
			mnAbsLineIndex = oSource.mnAbsLineIndex;
			moOffset = oSource.moOffset;
		}

		return this;
	}
}
