//----------------------------------------------------------------------
//
// File: mkField.h
//
// Description
//	Public header file for class MkField
//
//		This is a class that helps enumerate embedded fields in a
//		stream It uses the markup translation framework, saving
//		only pointers to embedded fields encountered.  Note that
//		the caller should run the markup with bFlattenFields set
//		to FALSE.
//
// Change history
//	Project 	Release Date	Who 	Review	What
//	HawaiiRd	5.0 	951006	RD				Created.
//
//----------------------------------------------------------------------

package com.adobe.xfa.text.markup;

import java.util.List;

import com.adobe.xfa.text.TextField;


/**
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */
public class MarkupField extends MarkupOut {
	private final List<TextField> mpoFieldOut;

	MarkupField (List<TextField> poFieldOut) {
		mpoFieldOut = poFieldOut;
		mpoFieldOut.clear();
	}

// Inherited from class TextMkOut.
	public void field (TextField poField) {
		mpoFieldOut.add (poField);
	}

	public boolean suppressAttributes () {
		return true;
	}
}
