/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.ut;

import java.util.ArrayList;
import java.util.List;

/**
 * A storage utility class which extends java.util.ArrayList with C++-like
 * operations.
 * @exclude from published API.
 */
public class Storage<T> extends ArrayList<T> {

	/*
	 * serialver-generated UID.
	 */
	private static final long serialVersionUID = -3453467565507172287L;

	/**
	 * Creates a storage with initially empty storage.
	 */
	public Storage() {
	}

	/**
	 * Creates a storage with a given size.  This doesn't
	 * actually populate those elements; the size reported will be zero
	 * until the elements are populated by the calling application.
	 * @param size initial allocation size.
	 */
	public Storage(int size) {
		super(size);
	}

	/**
	 * Copies a given storage.  Populates the new storage with
	 * each element in the source storage.
	 * @param storage source storage.
	 */
	public Storage(List<T> storage) {
		super(storage.size());
		for (int i = 0; i < storage.size(); i++) {
			add(storage.get(i));
		}
	}

	/**
	 * Sets the size to the given.  This method may truncate the
	 * storage if the new size is smaller or pad the storage with null
	 * values if the new size is larger.  This method will affect the size
	 * reported by the size() method.
	 * @param size new size for the storage.
	 */
	public void setSize(int size) {
		int oldSize = size();
		if (size < oldSize) {
			removeRange(size, oldSize);
		} else if (size > oldSize) {
			ensureCapacity(size);
			while (oldSize++ < size) {
				add(null);
			}
		}
	}

	/**
	 * Returns the last element in the storage.
	 * @return the last element in the storage; null if the storage is empty.
	 */
	public T last() {
		int end = size();
		return (end > 0) ? get(end - 1) : null;
	}

	/**
	 * Removes the last element from the storage.
	 */
	public void removeLast() {
		int end = size();
		if (end > 0) {
			setSize(end - 1);
		}
	}

}
