package com.adobe.xmp.core.namespace;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;


/**
 * Defines prefix/namespace contract for the standard namespaces.
 */
public class DefaultPrefixContract extends HashMap<String, String>
{
	private static final long serialVersionUID = 9169953737065019512L;

	/** 
	 * A prefix to namespace map that contains the default prefixes and 
	 * namespaces from the XMP specifications.
	 */
	private static HashMap<String, String> instance;
	
	/**
	 * Private constructor
	 */
	private DefaultPrefixContract() {}

    private final static Object synchronizer = new Object();

	/**
	 * @return Returns an unmodifiable version of the prefix to namespace map.
	 */
	public static Map<String, String> getInstance()
	{
		if (instance == null) { //avoid synchronized call if already initialized
			synchronized (synchronizer) {
				if (instance == null) { //instance might be initialized in the meantime!
					initialize();
				}
			}
		}
		return Collections.unmodifiableMap( instance );
	}

	/**
	 * Initializes the map of default prefix to namespace-mappings.
	 * <em>Note:</em> Prefixes of the form ns1, ns2... are not allowed as defaults,
	 * they are used by the NamespaceResolver.
	 */
	private static void initialize()
	{
		HashMap<String, String> tmpMap = new HashMap<>();

		// XML / RDF namespaces
		tmpMap.put( XML.STANDARD_PREFIX, XML.URI );
		tmpMap.put( RDF.STANDARD_PREFIX, RDF.URI );

		// Top-level schema namespaces
		tmpMap.put( AdobePDF.STANDARD_PREFIX, AdobePDF.URI );
		tmpMap.put( CameraRaw.STANDARD_PREFIX, CameraRaw.URI );
		tmpMap.put( DublinCore.STANDARD_PREFIX, DublinCore.URI );
		tmpMap.put( EXIFSchemaForAdditionalEXIF.STANDARD_PREFIX, EXIFSchemaForAdditionalEXIF.URI );
		tmpMap.put( EXIFSchemaForEXIF.STANDARD_PREFIX, EXIFSchemaForEXIF.URI );
		tmpMap.put( EXIFSchemaForTIFF.STANDARD_PREFIX, EXIFSchemaForTIFF.URI );
		tmpMap.put( Photoshop.STANDARD_PREFIX, Photoshop.URI );
		tmpMap.put( XMPBasic.STANDARD_PREFIX, XMPBasic.URI );
		tmpMap.put( XMPBasicJobTicket.STANDARD_PREFIX, XMPBasicJobTicket.URI );
		tmpMap.put( XMPDynamicMedia.STANDARD_PREFIX, XMPDynamicMedia.URI );
		tmpMap.put( XMPMediaManagement.STANDARD_PREFIX, XMPMediaManagement.URI );
		tmpMap.put( XMPPagedText.STANDARD_PREFIX, XMPPagedText.URI );
		tmpMap.put( XMPRightsManagement.STANDARD_PREFIX, XMPRightsManagement.URI );
		
		// type namespaces
		tmpMap.put( ResourceRef.STANDARD_PREFIX, ResourceRef.URI );
		tmpMap.put( ResourceEvent.STANDARD_PREFIX, ResourceEvent.URI );
		
		// TODO add rest of standard namespace mappings

		// initialize finished
		instance = tmpMap;
	}
}
